ALTER TABLE dbo.REGION
ADD CONSTRAINT PK_REGION PRIMARY KEY (R_REGIONKEY);
GO

-- For table NATION
ALTER TABLE dbo.NATION
ADD CONSTRAINT PK_NATION PRIMARY KEY (N_NATIONKEY);
GO

ALTER TABLE dbo.NATION
ADD CONSTRAINT FK_NATION_REGION FOREIGN KEY (N_REGIONKEY) REFERENCES dbo.REGION (R_REGIONKEY);
GO

-- For table PART
ALTER TABLE dbo.PART
ADD CONSTRAINT PK_PART PRIMARY KEY (P_PARTKEY);
GO

-- For table SUPPLIER
ALTER TABLE dbo.SUPPLIER
ADD CONSTRAINT PK_SUPPLIER PRIMARY KEY (S_SUPPKEY);
GO

ALTER TABLE dbo.SUPPLIER
ADD CONSTRAINT FK_SUPPLIER_NATION FOREIGN KEY (S_NATIONKEY) REFERENCES dbo.NATION (N_NATIONKEY);
GO

-- For table PARTSUPP
-- 删除重复的键值
WITH CTE AS (
    SELECT PS_PARTKEY, PS_SUPPKEY, ROW_NUMBER() OVER (PARTITION BY PS_PARTKEY, PS_SUPPKEY ORDER BY PS_PARTKEY) AS rn
    FROM dbo.PARTSUPP
)
DELETE FROM CTE WHERE rn > 1;

ALTER TABLE dbo.PARTSUPP
ADD CONSTRAINT PK_PARTSUPP PRIMARY KEY (PS_PARTKEY, PS_SUPPKEY);
GO

-- For table CUSTOMER
ALTER TABLE dbo.CUSTOMER
ADD CONSTRAINT PK_CUSTOMER PRIMARY KEY (C_CUSTKEY);
GO

ALTER TABLE dbo.CUSTOMER
ADD CONSTRAINT FK_CUSTOMER_NATION FOREIGN KEY (C_NATIONKEY) REFERENCES dbo.NATION (N_NATIONKEY);
GO

-- For table LINEITEM
ALTER TABLE dbo.LINEITEM
ADD CONSTRAINT PK_LINEITEM PRIMARY KEY (L_ORDERKEY, L_LINENUMBER);
GO

-- For table ORDERS
ALTER TABLE dbo.ORDERS
ADD CONSTRAINT PK_ORDERS PRIMARY KEY (O_ORDERKEY);
GO

-- For table PARTSUPP
ALTER TABLE dbo.PARTSUPP
ADD CONSTRAINT FK_PARTSUPP_SUPPLIER FOREIGN KEY (PS_SUPPKEY) REFERENCES dbo.SUPPLIER (S_SUPPKEY);
GO

ALTER TABLE dbo.PARTSUPP
ADD CONSTRAINT FK_PARTSUPP_PART FOREIGN KEY (PS_PARTKEY) REFERENCES dbo.PART (P_PARTKEY);
GO

-- For table ORDERS
ALTER TABLE dbo.ORDERS
ADD CONSTRAINT FK_ORDERS_CUSTOMER FOREIGN KEY (O_CUSTKEY) REFERENCES dbo.CUSTOMER (C_CUSTKEY);
GO

-- For table LINEITEM
ALTER TABLE dbo.LINEITEM
ADD CONSTRAINT FK_LINEITEM_ORDERS FOREIGN KEY (L_ORDERKEY) REFERENCES dbo.ORDERS (O_ORDERKEY);
GO

ALTER TABLE dbo.LINEITEM
ADD CONSTRAINT FK_LINEITEM_PARTSUPP FOREIGN KEY (L_PARTKEY, L_SUPPKEY) REFERENCES dbo.PARTSUPP (PS_PARTKEY, PS_SUPPKEY);
GO